import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  *
  * Beschreibung
  *
  * @version 1.0 vom 28.03.2013
  * @author vom Hau
  */

public class MonoAlphAnwendung extends JFrame {
  // Anfang Attribute
  private EinAus ein, aus;
  private JLabel jLabel1 = new JLabel();
  private JButton btVerschluesseln = new JButton();
  private JButton btEnde = new JButton();
  private JTextField tfPermAlphabet = new JTextField();
  // Ende Attribute
  
  public MonoAlphAnwendung(String title) {
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 300; 
    int frameHeight = 178;
    setSize(frameWidth, frameHeight);
    
    setLocation(50, 100);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    jLabel1.setBounds(8, 8, 131, 25);
    jLabel1.setText("permutiertes Alphabet");
    cp.add(jLabel1);
    btVerschluesseln.setBounds(8, 72, 129, 33);
    btVerschluesseln.setText("verschlsseln");
    btVerschluesseln.setMargin(new Insets(2, 2, 2, 2));
    btVerschluesseln.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btVerschluesseln_ActionPerformed(evt);
      }
    });
    cp.add(btVerschluesseln);
    btEnde.setBounds(152, 72, 129, 33);
    btEnde.setText("Ende");
    btEnde.setMargin(new Insets(2, 2, 2, 2));
    btEnde.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        ein.dispose(); aus.dispose();
        System.exit(0);
      }
    });
    cp.add(btEnde);
    setTitle("Monoalphabetische Substitution");
    tfPermAlphabet.setBounds(8, 40, 273, 25);
    tfPermAlphabet.setText("EXDBFGYULKMJNOTQRSAIPWCHZV");
    cp.add(tfPermAlphabet);
    // Ende Komponenten
    ein = new EinAus("Eingabe");
    aus = new EinAus("Ausgabe");
    aus.setLocation(470,420);
    ein.schreibeZeile("TESTTEXT");
    setVisible(true);
  } // end of public MonoAlphAnwendung
  
  // Anfang Methoden
  public void btVerschluesseln_ActionPerformed(ActionEvent evt) {
    String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String einString, ausString, permAlph;
    int nr;
    
    einString = ein.getZeile(0);
    ausString = "";
    permAlph = tfPermAlphabet.getText();
    
    for (int i=0;i<einString.length() ;i++ ) {
      nr = alphabet.indexOf( einString.substring(i, i+1));
      if (nr > -1) {
        
        ausString = ausString + permAlph.charAt(nr);
      } // end of if
      
      
    } // end of for
    aus.schreibeZeile(ausString);
  } // end of btVerschluesseln_ActionPerformed
  
  
  
  public static void main(String[] args) {
    new MonoAlphAnwendung("CaesarAnwendung");
  } // end of main
  
} // end of class MonoAlphAnwendung
